/////////////////////////////////////////////////////////////
// CINEMA SDK : TOOLS																			 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_TOOLPLUGIN_H
#define __C4D_TOOLPLUGIN_H

#include "ge_math.h"
#include "c4d_tooldata.h"
#include "c4d_baseplugin.h"

class EditorWindow
{
	private:
		EditorWindow(void);

	public:
		void DrawXORLine(LONG x1,LONG y1,LONG x2,LONG y2);

		void MouseDragStart(LONG button,Real mx,Real my,LONG flag); // button: BFM_INPUT_xxx, flags: MOUSEDRAG_xxx
		LONG MouseDrag(Real *mx,Real *my,BaseContainer *channels); // result: MOUSEDRAG_xxx
		LONG MouseDragEnd(void);

		Bool BfGetInputState(LONG askdevice,LONG askchannel,BaseContainer *res); // device: BFM_INPUT_MOUSE,BFM_INPUT_KEYBOARD, channel: BFM_INPUT_MOUSE_xxx
		Bool BfGetInputEvent(LONG askdevice,BaseContainer *res);                 // device: BFM_INPUT_MOUSE,BFM_INPUT_KEYBOARD,

		void StatusSetText(const String &str);
};

// MouseDrag channel values
enum
{
	PENPRESSURE          = 1,
	PENTILT              = 2,
	PENROTATION					 = 3,
	PENDRAWROTATION	     = 4,
	PENDRAWRANDOMNESS    = 5,
	PENDRAWWHEELROTATION = 6,
	PENDRAWWHEELPRESSURE = 7,
	PENDRAWDISTANCE      = 8,
	PENFINGERWHEEL       = 9
};


// return values for Draw()
#define DRAW_HANDLES					(1<<0)
#define DRAW_AXIS							(1<<1)

#define DRAWFLAGS_INVERSE_Z		(1)

#define PLUGINFLAG_TOOL_EVALUATEHANDLES	(1<<28)
#define PLUGINFLAG_TOOL_FORCESHADING		(1<<0)

struct TOOLPLUGIN : public STATICPLUGIN
{
	String			*help;
	BaseBitmap	*command_icon;

	Bool				(ToolData::*InitTool			)(BaseDocument *doc, BaseContainer &data, BaseThread *bt);
	void				(ToolData::*FreeToolEx		)(void);

	Bool				(ToolData::*MouseInput		)(BaseDocument *doc, BaseContainer &data, BaseDraw *bd, EditorWindow *win, const BaseContainer &msg);
	LONG				(ToolData::*GetState			)(BaseDocument *doc);
	Bool        (ToolData::*GetCursorInfo )(BaseDocument *doc, BaseContainer &data, BaseDraw *bd, Real x, Real y, BaseContainer &bc);
	LONG        (ToolData::*Draw          )(BaseDocument *doc, BaseContainer &data, BaseDraw *bd, BaseDrawHelp *bh, BaseThread *bt, LONG flags);

	CDialog*		(ToolData::*AllocDialog   )(BaseContainer *bc, CDialog *cd_parent, LONG dlg_id);
	void				(ToolData::*FreeDialog    )(CDialog *cd);

	Bool				(ToolData::*InitDisplayControl)(BaseDocument *doc, BaseContainer &data, BaseDraw *bd, AtomArray *active);
	void				(ToolData::*FreeDisplayControl)(void);
	Bool				(ToolData::*DisplayControl		)(BaseDocument *doc, BaseObject *op, BaseObject *chainstart, BaseDraw *bd, BaseDrawHelp *bh, ControlDisplayStruct &cds);

	void				(ToolData::*FreeTool			)(BaseDocument *doc, BaseContainer &data);

	void*	reserved[(32-12)*C4DPL_MEMBERMULTIPLIER-2];
};

#endif
